
----------------------------------------------------------------------
-- Script to Create and populate the DynamicImportsDB Database
----------------------------------------------------------------------
USE [master]
GO

/****** Object:  Database [DynamicImportsDB]    Script Date: 12-5-2018 16:31:18 ******/
CREATE DATABASE [DynamicImportsDB]
 CONTAINMENT = NONE
 ON  PRIMARY 
( NAME = N'DynamicImportsDB', FILENAME = N'D:\SQLServerData\DataFiles\DynamicImportsDB.mdf' , SIZE = 12288KB , MAXSIZE = UNLIMITED, FILEGROWTH = 1024KB )
 LOG ON 
( NAME = N'DynamicImportsDB_log', FILENAME = N'D:\SQLServerData\LogFiles\DynamicImportsDB_log.ldf' , SIZE = 1536KB , MAXSIZE = 2048GB , FILEGROWTH = 10%)
GO

ALTER DATABASE [DynamicImportsDB] SET COMPATIBILITY_LEVEL = 120
GO

IF (1 = FULLTEXTSERVICEPROPERTY('IsFullTextInstalled'))
begin
EXEC [DynamicImportsDB].[dbo].[sp_fulltext_database] @action = 'enable'
end
GO

ALTER DATABASE [DynamicImportsDB] SET ANSI_NULL_DEFAULT OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET ANSI_NULLS OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET ANSI_PADDING OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET ANSI_WARNINGS OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET ARITHABORT OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET AUTO_CLOSE OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET AUTO_SHRINK OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET AUTO_UPDATE_STATISTICS ON 
GO

ALTER DATABASE [DynamicImportsDB] SET CURSOR_CLOSE_ON_COMMIT OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET CURSOR_DEFAULT  GLOBAL 
GO

ALTER DATABASE [DynamicImportsDB] SET CONCAT_NULL_YIELDS_NULL OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET NUMERIC_ROUNDABORT OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET QUOTED_IDENTIFIER OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET RECURSIVE_TRIGGERS OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET  DISABLE_BROKER 
GO

ALTER DATABASE [DynamicImportsDB] SET AUTO_UPDATE_STATISTICS_ASYNC OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET DATE_CORRELATION_OPTIMIZATION OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET TRUSTWORTHY OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET ALLOW_SNAPSHOT_ISOLATION OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET PARAMETERIZATION SIMPLE 
GO

ALTER DATABASE [DynamicImportsDB] SET READ_COMMITTED_SNAPSHOT OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET HONOR_BROKER_PRIORITY OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET RECOVERY SIMPLE 
GO

ALTER DATABASE [DynamicImportsDB] SET  MULTI_USER 
GO

ALTER DATABASE [DynamicImportsDB] SET PAGE_VERIFY CHECKSUM  
GO

ALTER DATABASE [DynamicImportsDB] SET DB_CHAINING OFF 
GO

ALTER DATABASE [DynamicImportsDB] SET FILESTREAM( NON_TRANSACTED_ACCESS = OFF ) 
GO

ALTER DATABASE [DynamicImportsDB] SET TARGET_RECOVERY_TIME = 0 SECONDS 
GO

ALTER DATABASE [DynamicImportsDB] SET DELAYED_DURABILITY = DISABLED 
GO

ALTER DATABASE [DynamicImportsDB] SET  READ_WRITE 
GO



------------------------------------------------------------
-- Create tables
------------------------------------------------------------
USE [DynamicImportsDB]
GO

/****** Object:  Table [dbo].[TempTable]    Script Date: 12-5-2018 16:32:12 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

SET ANSI_PADDING ON
GO

CREATE TABLE [dbo].[TempTable](
	[Channel] [varchar](100) NOT NULL,
	[TimeBand] [varchar](50) NOT NULL,
	[Column1] [float] NULL,
	[Column2] [float] NULL,
	[Column3] [float] NULL,
	[Column4] [float] NULL
) ON [PRIMARY]

GO

CREATE TABLE [dbo].[TempTableMappings](
	[MappingID] [int] IDENTITY(1,1) NOT NULL,
	[MappingFormatID] [int] NOT NULL,
	[MapFromField] [varchar](50) NOT NULL,
	[MapToField] [varchar](50) NOT NULL,
 CONSTRAINT [PK_TempTableMappings] PRIMARY KEY CLUSTERED 
(
	[MappingID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

SET ANSI_PADDING OFF
GO




------------------------------------------------------------
-- Create the required mappings in TempTableMappings
------------------------------------------------------------
INSERT INTO dbo.TempTableMappings(MappingFormatID, MapFromField, MapToField)
SELECT				1, 'Channel',	'Channel'
UNION ALL SELECT	1, 'TimeBand',	'TimeBand'
UNION ALL SELECT	1, 'AA1',		'Column1'
UNION ALL SELECT	1, ' B2',		'Column2'
UNION ALL SELECT	1, ' AC',		'Column4'
UNION ALL SELECT	2, 'Channel',	'Channel'
UNION ALL SELECT	2, 'TimeBand',	'TimeBand'
UNION ALL SELECT	2, 'AA1',		'Column1'
UNION ALL SELECT	2, 'AB1',		'Column3'

GO